<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!can_access_logs($vbulletin->config['SpecialUsers']['canviewadminlog']))
{
	// We have no perms
	print_cp_no_permission();
}

print_cp_header($vbphrase['dbtech_vbsecurity_ipverify_cp_header']);

// ###################### Start modify #######################
if ($_REQUEST['action'] == 'acplogins' OR empty($_REQUEST['action']))
{
	$users = $db->query_read_slave("
		SELECT DISTINCT ipverify.userid, user.username
		FROM " . TABLE_PREFIX . "dbtech_vbsecurity_ipverify AS ipverify
		LEFT JOIN " . TABLE_PREFIX . "user AS user USING(userid)
		ORDER BY username
	");
	$userlist = array('no_value' => $vbphrase['dbtech_vbsecurity_ipverify_all_log_entries']);
	while ($user = $db->fetch_array($users))
	{
		$userlist["$user[userid]"] = $user['username'];
	}

	print_form_header('vbsecurity', 'acplogins');
	construct_hidden_code('action', 'view');
	print_table_header($vbphrase['dbtech_vbsecurity_ipverify_table_header']);
	print_input_row($vbphrase['log_entries_to_show_per_page'], 'perpage', 15);
	print_select_row($vbphrase['user_name'], 'userid', $userlist);
	print_time_row($vbphrase['start_date'], 'startdate', 0, 0);
	print_time_row($vbphrase['end_date'], 'enddate', 0, 0);
	print_input_row($vbphrase['ip_address'], 'ipaddress');
	print_select_row($vbphrase['order_by'], 'orderby', array('date' => $vbphrase['date'], 'user' => $vbphrase['username']), 'date');

	/*
	print_input_row('<span style="padding-right:60px;">' . $vbphrase['dbtech_vbsecurity_ipverify_log_entries_to_show_per_page'], 'perpage' . '</span>', 25);
	print_select_row($vbphrase['order_by'], 'orderby', array(
		'DESC' 	=> $vbphrase['descending'],
		'ASC' 	=> $vbphrase['ascending']
	));
	*/
	print_submit_row($vbphrase['dbtech_vbsecurity_ipverify_show_entries'], 0);

	if (can_access_logs($vbulletin->config['SpecialUsers']['canpruneadminlog'], 1))
	{
		print_form_header('vbsecurity', 'acplogins');
		construct_hidden_code('action', 'prune');
		print_table_header($vbphrase['prune_log_entries']);
		print_select_row($vbphrase['dbtech_vbsecurity_remove_entries_user'], 'userid', $userlist, 'no_value');
		print_input_row($vbphrase['dbtech_vbsecurity_remove_entries_days'], 'daysprune', 30);
		print_submit_row($vbphrase['prune_log_entries'], 0);
	}
}

// ###################### Start view #######################
if ($_REQUEST['action'] == 'view')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'perpage'    => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		'userid'     => TYPE_UINT,
		'orderby'    => TYPE_NOHTML,
		'startdate'  => TYPE_UNIXTIME,
		'enddate'    => TYPE_UNIXTIME,
		'ipaddress'	 => TYPE_STR,
	));

	$sqlconds = array();
	$hook_query_fields = $hook_query_joins = '';

	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 15;
	}

	if ($vbulletin->GPC['userid'])
	{
		$sqlconds[] = "ipverify.userid = " . $vbulletin->GPC['userid'];
	}

	if ($vbulletin->GPC['startdate'])
	{
		$sqlconds[] = "ipverify.dateline >= " . $vbulletin->GPC['startdate'];
	}

	if ($vbulletin->GPC['enddate'])
	{
		$sqlconds[] = "ipverify.dateline <= " . $vbulletin->GPC['enddate'];
	}

	if ($vbulletin->GPC['ipaddress'])
	{
		$sqlconds[] = 'ipverify.ipaddress LIKE \'%' . $vbulletin->GPC['ipaddress'] . '%\'';
	}

	$counter = VBSECURITY::$db->fetchOne('
		SELECT COUNT(*) AS total
		FROM $dbtech_vbsecurity_ipverify AS ipverify
		LEFT JOIN $user AS user USING(userid)
		:hookJoinFields
		:where
	', array(
		':hookJoinFields' 	=> $hook_join_fields,
		':where' 			=> (!empty($sqlconds) ? 'WHERE ' . implode("\r\n\tAND ", $sqlconds) : ''),
	));
	$totalpages = ceil($counter / $vbulletin->GPC['perpage']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	switch($vbulletin->GPC['orderby'])
	{
		case 'user':
			$order = 'user.username ASC, dateline DESC';
			break;
		case 'date':
		default:
			$order = 'dateline DESC';
	}

	// Query the messages
	$logs = VBSECURITY::$db->fetchAllKeyed('
		SELECT ipverify.*, user.username
			:hookQueryFields
		FROM $dbtech_vbsecurity_ipverify AS ipverify
		LEFT JOIN $user AS user USING(userid)
		:hookJoinFields
		:where
		ORDER BY :order
		LIMIT :limitStart, :limitEnd
	', 'transactionid', array(
		':hookQueryFields' 	=> $hook_query_fields,
		':hookJoinFields' 	=> $hook_join_fields,
		':where' 			=> (!empty($sqlconds) ? 'WHERE ' . implode("\r\n\tAND ", $sqlconds) : ''),
		':order' 			=> $order,
		':limitStart' 		=> $startat,
		':limitEnd' 		=> $vbulletin->GPC['perpage']
	));

	if (count($logs))
	{
		if ($vbulletin->GPC['pagenumber'] != 1)
		{
			$prv = $vbulletin->GPC['pagenumber'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=acplogins&action=view&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=acplogins&action=view&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$prv'\">";
		}

		if ($vbulletin->GPC['pagenumber'] != $totalpages)
		{
			$nxt = $vbulletin->GPC['pagenumber'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=acplogins&action=view&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=acplogins&action=view&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$totalpages'\">";
		}

		$headings = array();
		$headings[] = "<a href=\"vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=acplogins&action=view&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=date&page=" . $vbulletin->GPC['pagenumber'] . "\">" . $vbphrase['date'] . "</a>";
		$headings[] = "<a href=\"vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=acplogins&action=view&u=" . $vbulletin->GPC['userid'] . "&pp=" . $vbulletin->GPC['perpage'] . "&orderby=user&page=" . $vbulletin->GPC['pagenumber'] . "\">" . str_replace(' ', '&nbsp;', $vbphrase['username']) . "</a>";
		$headings[] = str_replace(' ', '&nbsp;', $vbphrase['ip_address']);

		print_form_header('', '');
		print_description_row(construct_link_code($vbphrase['restart'], "vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=acplogins"), false, count($headings), 'thead', 'right');
		print_table_header(construct_phrase($vbphrase['dbtech_vbsecurity_ipverify_list_page_x_y_there_are_z_total_log_entries'], vb_number_format($vbulletin->GPC['pagenumber']), vb_number_format($totalpages), vb_number_format($counter)), count($headings));
		print_cells_row($headings, 1);

		foreach ($logs as $log)
		{
			// Ensure this is correct
			$log['username'] = ($log['username'] ? $log['username'] : 'user id: ' . intval($user['userid']));

			$cell = array();
			$cell[] = '<span class="smallfont">' . vbdate($vbulletin->options['logdateformat'], $log['dateline']) . '</span>';
			$cell[] = "<a href=\"vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=acplogins&action=view&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=1&u=" . $log['userid'] . "\">$log[username]</a>";
			$cell[] = "<a href=\"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=doips&depth=2&ipaddress=$log[ipaddress]&hash=" . CP_SESSIONHASH . "\">$log[ipaddress]</a>";

			print_cells_row($cell, 0, 0, -4);
		}

		print_table_footer(count($headings), "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		print_stop_message('no_results_matched_your_query');
	}
}

// ###################### Start prune log #######################
if ($_REQUEST['action'] == 'prune' AND can_access_logs($vbulletin->config['SpecialUsers']['canpruneadminlog'], '<p>' . $vbphrase['dbtech_vbsecurity_log_pruning_restricted'] . '</p>'))
{
	$vbulletin->input->clean_array_gpc('r', array(
		'userid'	=> TYPE_INT,
		'daysprune'	=> TYPE_INT
	));

	$datecut = TIMENOW - (86400 * $vbulletin->GPC['daysprune']);
	$query = "SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "dbtech_vbsecurity_ipverify WHERE dateline < $datecut";

	if ($vbulletin->GPC['userid'])
	{
		$query .= "\nAND userid = " . $vbulletin->GPC['userid'];
	}

	$logs = $db->query_first_slave($query);
	if ($logs['total'])
	{
		print_form_header('vbsecurity', 'acplogins');
		construct_hidden_code('action', 'do_prune');
		construct_hidden_code('datecut', $datecut);
		construct_hidden_code('userid', $vbulletin->GPC['userid']);
		print_table_header($vbphrase['dbtech_vbsecurity_prune_log_entries']);
		print_description_row(construct_phrase($vbphrase['dbtech_vbsecurity_prune_log_entries_verify'], vb_number_format($logs['total'])));
		print_submit_row($vbphrase['yes'], 0, 0, $vbphrase['no']);
	}
	else
	{
		print_stop_message('no_results_matched_your_query');
	}

}

// ###################### Start do prune log #######################
if ($_POST['action'] == 'do_prune' AND can_access_logs($vbulletin->config['SpecialUsers']['canpruneadminlog'], '<p>' . $vbphrase['dbtech_vbsecurity_log_pruning_restricted'] . '</p>'))
{
	$vbulletin->input->clean_array_gpc('p', array(
		'userid'	=> TYPE_INT,
		'datecut'	=> TYPE_INT
	));

	$query = "DELETE FROM " . TABLE_PREFIX . "dbtech_vbsecurity_ipverify WHERE dateline < " . $vbulletin->GPC['datecut'];

	if ($vbulletin->GPC['userid'])
	{
		$query .= "\nAND userid = " .  $vbulletin->GPC['userid'];
	}

	$db->query_write($query);

	define('CP_REDIRECT', 'vbsecurity.php?do=acplogins');
	print_stop_message('dbtech_vbsecurity_log_pruned_successfully');
}

print_cp_footer();
?>